program select_sort_file;
uses
  CRT, FileUtil, OutScr, SysUtils;
type
  manager= record
  name: string[18];
  comp: integer;
 end;
var
  company: manager;
  f_not_sorted, f_sorted: File of manager; // Файловая переменная
  vector: array of manager;
  i, n: integer;
  name_file: string;

{ Сортировка выбором, файла по фамилиям менеджеров }
procedure select (var vector: array of manager);
var
  i, j, count, min: integer;
  t: manager;
begin
  count:= high(vector);
  for i:= 0 to count - 1 do
  begin
   min:= i;
   for j:= i + 1 to count do
   if vector[j].comp > vector[min].comp then min:= j;
   t:= vector[min];
   vector[min]:= vector[i];
   vector[i]:= t;
  end;
end;
{  ====================================================== }

begin
  {При необходимости укажите полный путь к файлу
   или скопируйте файл в папку с данным проектом}
  if not FileExists('File_not_sorted.dat') then
  begin
    writeln(UTF8ToConsole('Файлы не существуют'));
    writeln(UTF8ToConsole('Сначала создайте их'));
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    exit;
  end;
  AssignFile(f_not_sorted,'File_not_sorted.dat');
  Reset(f_not_sorted);
  n:= System.FileSize(f_not_sorted); // Определение количества записей в файле
  SetLength(vector, n);
  {Подготовка к внутренней сортировке,
  считывание записей файла в массив,
  в процедуру передается массив, а не файл.}
  i:= 0;
  while not Eof(f_not_sorted) do
  begin
     Read(f_not_sorted, company);
     vector[i]:= company; // массив, который будет сортироваться
     i:= i + 1;
  end;
  select(vector); // вызов процедуры сортировки методом выбора
  CloseFile(f_not_sorted);
  AssignFile(f_sorted, 'File_sorted.dat');
  Rewrite(f_sorted);
  for i:= 0 to n - 1 do
  Write(f_sorted, vector[i]);
  CloseFile(f_sorted);
  name_file:= 'File_sorted.dat';
  {Вызов процедуры для вывода на экран сводной ведомости.
  Процедура находится в модуле OutScr}
  output_to_screen(name_file);
  write(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.

